#*************************************************************************************************************
# Name: Battleracer - Circuit Racing Gamemode
# Author: Elxx
# Version 1.29 (+Christmas Pack)
#*************************************************************************************************************
# Conditions and Limitations: You may use this file locally, on listening and dedicated servers. You MAY NOT
# copy, redistribute, nor modify this file without the expressed permission of the Battleracer team.
# This software is provided "as is". In no event shall the author, authors or contributors be held
# liable for  any direct, indirect, incidental, special, exemplary, or consequential damages (including)
# but not limited to, procurement of substitute good or services; loss of use, data or profits; or
# business interruption) however caused and on any theory of liability, whether in contract, strict liability
# arising in any way out of the use of this software, even if advised of the possibility of such damage.
#*************************************************************************************************************
# Mach10, suck it. I wrote this code and I will not tolerate you trying to take credit for it. I acknowledge
# the fact that you created the first "Rally Racing" game mode for BF2. Now get your head out of your ass,
# you hypocrite.
#*************************************************************************************************************

class Battleracer:
	def __init__(self):
		self.shortRaceLaps = 4
		self.longRaceLaps = 3
		self.intRaceLaps = 2
		self.raceCountdownTime = 100
		self.statsCode = ""
		self.exitPenalty = 15
		self.exitThreshold = 4
		self.enableFF = 1
		self.handheldWeapons = 1
		self.vehicleWeapons = 1
		self.weaponsDisabled = 0

		self.displayWinnersTimerIndex = 0
		self.raceStarted = False
		self.startCountdown = 60
		self.startTime = 0.0
		self.mapSize = 16
		self.raceIsEnded = 0

		self.endRaceTimer = None
		self.displayWinnersTimer = None
		self.lastChanceTimer = None
		self.penaltyTimer = None
		self.raceStartTimer = None

		self.player_timesplit = {}
		self.player_totaltime = {}
		self.player_bestlap = {}
		self.player_timepenalty = {}
		self.player_disqualified = {}
		self.player_startcheck = {}
		self.player_setExitPenalty = {}
		self.player_setDQ = {}
		self.player_resetTime = {}
		self.player_reset = {}

		self.player_currVehicle = {}
		self.player_lastVehicle = {}
		self.player_lastSVehicle = {}

		self.player_ids = {}

		self.banlist_name = []
		self.banlist_ip = []
		self.banlist_gsid = []

		self.STATS_SERVER = "205.234.105.49"
		self.STATS_PORT = 16570
		self.BRVERSION = "1.29"

	def destroyTimers(self):
		if self.raceStartTimer:
			self.raceStartTimer.destroy()
		if self.penaltyTimer:
			self.penaltyTimer.destroy()
		if self.lastChanceTimer:
			self.lastChanceTimer.destroy()
		if self.displayWinnersTimer:
			self.displayWinnersTimer.destroy()
		if self.endRaceTimer:
			self.endRaceTimer.destroy()

BR = Battleracer()

import host
import bf2
import math
import bf2.Timer
import sys
import socket
import md5
import inspect
import re
import ConfigParser
import errno
from game.scoringCommon import addScore, RPL
from bf2 import g_debug
from socket import *

g_controlPoints = [] # cache, as this map won't change
num_pts = 0

# ***************
# DEBUG FUNCTIONS
# ***************
a_debug = 0
class writer:
	def __init__(self, filename ):
		self.stream = open( filename, 'a+')

	def write(self, str):
		self.stream.write(str)
		self.stream.flush()
if a_debug: sys.stdout = sys.stderr = writer( 'br_debug.log' )

def ExceptionOutput():
	sys.stderr.write("\n" + "Exception Occured: " + str(sys.exc_info()[0]) + "\n")
	sys.stderr.write("Value: " + str(sys.exc_info()[1]) + "\n")
	sys.stderr.write("Line:" + str(readline(inspect.getfile(sys.exc_info()[2]),
					sys.exc_info()[2].tb_lineno)) + "\n")
	sys.stderr.write("Line #: " + str(sys.exc_info()[2].tb_lineno) + "\n")
	sys.stderr.write("File: " + str(inspect.getfile(sys.exc_info()[2])) + "\n" + "\n")

def readline(filename, lineno):
	filen = re.sub('\\\\', '/', filename)
	file = open(filen, 'rU')
	lines = file.readlines()
	file.close()
	linen = lineno - 1
	line = re.sub('\s+', ' ', lines[linen])
	return line
# ***************
# ***************

def init():
	# events hook
	host.registerGameStatusHandler(onGameStatusChanged)
	if host.sgl_getIsAIGame() == 1:
		host.sh_setEnableCommander(0)
	else:
		host.sh_setEnableCommander(0)

	if g_debug: print "gpm_rally.py initialized"

def deinit():
	bf2.triggerManager.destroyAllTriggers()
	global g_controlPoints
	g_controlPoints = []
	host.unregisterGameStatusHandler(onGameStatusChanged)
	if g_debug: print "gpm_rally.py uninitialized"

def onGameStatusChanged(status):

	global g_controlPoints
	global num_pts

	num_pts = 0

	Reset(0)

	if status == bf2.GameStatus.Playing:
		g_controlPoints = bf2.objectManager.getObjectsOfType('dice.hfe.world.ObjectTemplate.ControlPoint')
		for obj in g_controlPoints:
			radius = float(obj.getTemplateProperty('radius'))
			fteam = float(obj.cp_getParam('team'))
			if fteam == 2:
				checkpointnum = int(obj.getTemplateProperty('ControlPointID'))
				if checkpointnum == 1:
					id = bf2.triggerManager.createRadiusTrigger(obj, FinishTrigger, '<<PCO>>', radius, (1, 2, 3))
				elif checkpointnum == 2:
					id = bf2.triggerManager.createRadiusTrigger(obj, StartCheckTrigger, '<<PCO>>', radius, (1, 2, 3))
				else:
					id = bf2.triggerManager.createRadiusTrigger(obj, CheckpointTrigger, '<<PCO>>', radius, (1, 2, 3))
					num_pts += 1

				obj.triggerId = id
				obj.lastAttackingTeam = 0
		try:
			config = ConfigParser.ConfigParser()
			config.read("mods/battleracer2/settings/racesettings.ini")
			BR.longRaceLaps = int(config.get("races", "longlaps"))
			BR.shortRaceLaps = int(config.get("races", "shortlaps"))
			BR.intRaceLaps = int(config.get("races", "intlaps"))
			BR.raceCountdownTime = int(config.get("races", "racecountdowntime"))
			BR.enableFF = int(config.get("weapons", "friendlyfire"))
			BR.handheldWeapons = int(config.get("weapons", "handheldweapons"))
			BR.vehicleWeapons = int(config.get("weapons", "vehicleweapons"))
		except:
			BR.shortRaceLaps = 4
			BR.longRaceLaps = 3
			BR.intRaceLaps = 2
			BR.raceCountdownTime = 100
			BR.enableFF = 1
			BR.handheldWeapons = 1
			BR.vehicleWeapons = 1
			ExceptionOutput()

		try:
			config2 = ConfigParser.ConfigParser()
			config2.read("mods/battleracer2/settings/statsettings.ini")
			BR.statsCode = str(config2.get("stats", "statscode"))
		except:
			BR.statsCode = ""
			ExceptionOutput()

		if host.sgl_getMapName() == "seaside_raceway" or host.sgl_getMapName() == "seaside_night":
			if num_pts > 4:
				BR.mapSize = 32
			else:
				BR.mapSize = 16
		elif host.sgl_getMapName() == "mashtuur_city" or host.sgl_getMapName() == "strike_at_karkand":
			if num_pts == 7:
				BR.mapSize = 64
			elif num_pts == 6:
				BR.mapSize = 32
			else:
				BR.mapSize = 16
		elif host.sgl_getMapName() == "road_to_jalalabad":
			if num_pts == 7:
				BR.mapSize = 64
			elif num_pts == 5:
				BR.mapSize = 16
			else:
				BR.mapSize = 32
		elif host.sgl_getMapName().lower() == "dragon_valley":
			if num_pts >= 13:
				BR.mapSize = 64
			elif num_pts == 9:
				BR.mapSize = 32
			else:
				BR.mapSize = 16
		elif host.sgl_getMapName() == "kubra_dam":
			if num_pts >= 9:
				BR.mapSize = 64
			else:
				BR.mapSize = 32
		elif host.sgl_getMapName() == "gulf_of_oman":
			BR.mapSize = 32
		elif host.sgl_getMapName() == "urbanspeedway":
			BR.mapSize = 16
		elif host.sgl_getMapName() == "santas_race_track":
			BR.mapSize = 32

		if BR.mapSize == 64:
			BR.raceLaps = BR.intRaceLaps
		elif BR.mapSize == 32:
			BR.raceLaps = BR.longRaceLaps
		elif BR.mapSize == 16:
			BR.raceLaps = BR.shortRaceLaps
		else:
			BR.raceLaps = BR.longRaceLaps

		bf2.gameLogic.setTickets(1, 1)
		bf2.gameLogic.setTickets(2, 1)

		bf2.gameLogic.setTicketState(1, 0)
		bf2.gameLogic.setTicketState(2, 0)

		host.registerHandler('PlayerSpawn', onPlayerSpawn)
		host.registerHandler('EnterVehicle', onEnterVehicle)
		host.registerHandler('ExitVehicle', onExitVehicle)
		host.registerHandler('PlayerConnect', onPlayerConnect)
		host.registerHandler('PlayerDisconnect', onPlayerDisconnect)
		host.registerHandler('PlayerDeath', onPlayerDeath)
		host.registerHandler('DropKit', onDropKit)
		host.registerHandler('RemoteCommand', onRemoteCommand, 1)

		BR.raceStarted = False

		if not BR.lastChanceTimer:
			BR.lastChanceTimer = bf2.Timer(lastChanceRestart, 0 , 1)
			BR.lastChanceTimer.setRecurring(10.0)

		if not BR.penaltyTimer:
			BR.penaltyTimer = bf2.Timer(checkPenalty, 0 , 1)
			BR.penaltyTimer.setRecurring(1.0)

		'''try:
			banlistHandle = open ('mods/battleracer2/settings/banlist.txt')
			banlistString = banlistHandle.read()

			bList = banlistString.split("\n")

			for x in bList:
				y = x.split("\t")
				if y[0] == "ip":
					BR.banlist_ip.append(y[1])
				elif y[0] == "gsid":
					BR.banlist_gsid.append(y[1])
				elif y[0] == "name":
					BR.banlist_name.append(y[1])

			banlistHandle.close()
		except:
			ExceptionOutput()'''

		# if there's not enough players, don't start the countdown yet
		if bf2.playerManager.getNumberOfPlayers() >= int(host.rcon_invoke('sv.numPlayersNeededToStart')):
			startTiming()

		generateIDs()

		print "gpm_rally (Circuit) initialized."

	else:
		bf2.triggerManager.destroyAllTriggers()
		g_controlPoints = []

def startTiming():

	disableWeapons()
	BR.startCountdown = BR.raceCountdownTime

	if not BR.raceStartTimer:
		BR.raceStartTimer = bf2.Timer(raceStarter, 0 , 1)
		BR.raceStartTimer.setRecurring(1.0)

def formatTime(t):
	if t > 59:
		minutes = math.floor(t / 60)
		minutes_s = '%02d' % minutes
	else:
		minutes = 0
		minutes_s = '00'
	if t > 1:
		seconds = math.floor(t - (int(minutes) * 60))
		seconds_s = '%02d' % seconds
	else:
		seconds = 0
	mills = (t - (int(seconds) + (int(minutes) * 60))) * 100
	mills_s = '%02d' % mills
	return str(minutes_s) + ":" + str(seconds_s) + "." + str(mills_s)

def formatTimePart(t):
	if t > 59:
		minutes = math.floor(t / 60)
	else:
		minutes = 0
	if t > 1:
		seconds = math.floor(t - (int(minutes) * 60))
	else:
		seconds = 0
	mills = (t - (int(seconds) + (int(minutes) * 60))) * 100

	return int(minutes),int(seconds),int(mills)

def generateIDs():
	for p in bf2.playerManager.getPlayers():
		BR.player_ids[p.getName()] = p.index
		if not BR.player_disqualified.has_key(p.getName()):
			BR.player_disqualified[p.getName()] = 0
		if not BR.player_startcheck.has_key(p.getName()):
			BR.player_startcheck[p.getName()] = 0
		if not BR.player_currVehicle.has_key(p.getName()):
			BR.player_currVehicle[p.getName()] = 0
		if not BR.player_lastVehicle.has_key(p.getName()):
			BR.player_lastVehicle[p.getName()] = 0
		if not BR.player_setExitPenalty.has_key(p.getName()):
			BR.player_setExitPenalty[p.getName()] = 0
		if not BR.player_resetTime.has_key(p.getName()):
			BR.player_resetTime[p.getName()] = 0

_swap2 = lambda (x,y): (y,x)

def sortbyvalue(dict):
	mdict = map(_swap2, dict.items())
	mdict.sort()
	mdict = map(_swap2, mdict)
	return mdict

def onRemoteCommand(playerId, cmd):
		from math import pi

		if playerId == -1: #fix for local servers
			playerId = 255
		print "Command received: [" + str(cmd) + "] from [" + str(playerId) + "]"
		origCmd = cmd
		spacepos = origCmd.find(' ')
		if spacepos == -1: spacepos=len(cmd)
		cmd = origCmd[0:spacepos]
		cmdVar = origCmd[spacepos + 1:]
		if cmd == "flipMe":
			p = bf2.PlayerManager.Player(playerId)
			if (p.getVehicle() != p.getDefaultVehicle()) and (BR.player_resetTime[p.getName()] >= 10):
				pVeh = p.getVehicle()
				pPos = pVeh.getPosition()
				pRot = pVeh.getRotation()
				print pPos
				print pRot
				if (pRot[1] > 90.0) or (pRot[1] < -90.0) or (pRot[2] > 90.0) or (pRot[2] < -90.0):
					BR.player_reset[p.getName()] = [pPos,pRot]
					BR.player_resetTime[p.getName()] = 0


def raceStarter(data):

	#print "raceStarter"

	BR.startCountdown -= 1

	if BR.startCountdown > 0:
		bf2.gameLogic.setTickets(1, BR.startCountdown)
		bf2.gameLogic.setTickets(2, BR.startCountdown)
	else:
		bf2.gameLogic.setTickets(1, BR.raceLaps)
		bf2.gameLogic.setTickets(2, BR.raceLaps)

	if BR.startCountdown == 110:
		sendMsg("The race will start in 2 minutes. Drive to the start line and prepare your vehicle.")
	if BR.startCountdown == 90:
		sendMsg("The race will start in about 90 seconds. Drive to the start line and prepare your vehicle.")
	if BR.startCountdown == 60:
		sendMsg("The race will start in 1 minute. Drive to the start line and prepare your vehicle.")
	if BR.startCountdown == 30:
		sendMsg("The race will begin in 30 seconds.")
	if BR.startCountdown == 10:
		sendMsg("The race will begin in 10 seconds. Gentlemen, start your engines!")
		sendMsg("This will be a " + str(BR.raceLaps) + "-lap race.")
		if BR.enableFF:
			if BR.handheldWeapons:
				sendMsg("Handheld weapons are enabled.")
			else:
				sendMsg("Handheld weapons are DISABLED.")
			if BR.vehicleWeapons:
				sendMsg("Vehicle-mounted weapons are enabled.")
			else:
				sendMsg("Vehicle-mounted weapons are DISABLED.")
		else:
			sendMsg("Weapons and Friendly Fire are disabled for this race. Please drive cleanly.")
	if BR.startCountdown == 3:
		sendEmphMsg("   3            3            3            3")
	if BR.startCountdown == 2:
		sendEmphMsg("   2            2            2            2")
	if BR.startCountdown == 1:
		sendEmphMsg("   1             1             1             1")
	if BR.startCountdown == 0:
		sendEmphMsg("   GO          GO           GO           GO")
		BR.raceStarted = True
		BR.startTime = host.timer_getWallTime()
		controlPoints = bf2.objectManager.getObjectsOfType('dice.hfe.world.ObjectTemplate.ControlPoint')
		try:
			for cp in controlPoints:
				ptid = int(cp.getTemplateProperty('ControlPointID'))
				if ptid == 2:
					pcos = bf2.triggerManager.getObjects(cp.triggerId)
					for o in pcos:
						if not o: continue
						if o.getParent(): continue
						occupyingPlayers = o.getOccupyingPlayers()
						for p in occupyingPlayers:
							if p != occupyingPlayers[0]: continue
							if p.isAlive() and not p.isManDown():
								if not p.killed:
									if p.getDefaultVehicle() != p.getVehicle():
										if BR.player_disqualified[p.getName()] < 3:
											BR.player_startcheck[p.getName()] = 1
		except:
			ExceptionOutput()
	if BR.startCountdown <= -5:
		enableWeapons()

def sendMsg(msg):
	host.rcon_invoke("game.sayAll \"" + str(msg) + "\"")

def enableWeapons():
	disableWeapons()
	host.rcon_invoke("sv.soldierFriendlyFire 0")
	host.rcon_invoke("sv.vehicleFriendlyFire 0")
	host.rcon_invoke("sv.soldierSplashFriendlyFire 100")
	host.rcon_invoke("sv.vehicleSplashFriendlyFire 100")
	host.rcon_invoke("sv.spawnTime 4")
	host.rcon_invoke("sv.manDownTime 0")
	if BR.vehicleWeapons:
		host.rcon_invoke("ObjectTemplate.active HMG_M134_Gun")
		host.rcon_invoke("ObjectTemplate.projectileTemplate HMG_M134_Projectile")
		host.rcon_invoke("ObjectTemplate.velocity 500")
		host.rcon_invoke("ObjectTemplate.active HMG_M134_Projectile")
		host.rcon_invoke("ObjectTemplate.detonation.explosionDamage 200")
		host.rcon_invoke("ObjectTemplate.active HMG_M2HB")
		host.rcon_invoke("ObjectTemplate.projectileTemplate HMG_M2HB50cal_Projectile")
		host.rcon_invoke("ObjectTemplate.velocity 500")
		host.rcon_invoke("sv.vehicleFriendlyFire 100")
	if BR.handheldWeapons:
		host.rcon_invoke("ObjectTemplate.active kni_knife")
		host.rcon_invoke("ObjectTemplate.projectileTemplate kni_knife_Projectile")
		host.rcon_invoke("ObjectTemplate.velocity 40")
		host.rcon_invoke("ObjectTemplate.active uspis_92fs")
		host.rcon_invoke("ObjectTemplate.projectileTemplate USPIS_92FS_Projectile")
		host.rcon_invoke("ObjectTemplate.velocity 1000")
		host.rcon_invoke("sv.soldierFriendlyFire 100")
	BR.weaponsDisabled = 0

def disableWeapons():
	host.rcon_invoke("ObjectTemplate.active HMG_M134_Gun")
	host.rcon_invoke("ObjectTemplate.projectileTemplate HMG_M134_Projectile")
	host.rcon_invoke("ObjectTemplate.velocity 0")
	host.rcon_invoke("ObjectTemplate.active HMG_M134_Projectile")
	host.rcon_invoke("ObjectTemplate.detonation.explosionDamage 0")
	host.rcon_invoke("ObjectTemplate.active HMG_M2HB")
	host.rcon_invoke("ObjectTemplate.projectileTemplate HMG_M2HB50cal_Projectile")
	host.rcon_invoke("ObjectTemplate.velocity 0")
	host.rcon_invoke("ObjectTemplate.active kni_knife")
	host.rcon_invoke("ObjectTemplate.projectileTemplate kni_knife_Projectile")
	host.rcon_invoke("ObjectTemplate.velocity 0")
	host.rcon_invoke("ObjectTemplate.active uspis_92fs")
	host.rcon_invoke("ObjectTemplate.projectileTemplate USPIS_92FS_Projectile")
	host.rcon_invoke("ObjectTemplate.velocity 0")
	#host.rcon_invoke("ObjectTemplate.active JetMod_Engine_A")
	#host.rcon_invoke("ObjectTemplate.setInputToRoll PINone")
	#for p in bf2.playerManager.getPlayers():
	#	showContainment(p.getVehicle())
	host.rcon_invoke("sv.soldierFriendlyFire 0")
	host.rcon_invoke("sv.vehicleFriendlyFire 0")
	host.rcon_invoke("sv.soldierSplashFriendlyFire 100")
	host.rcon_invoke("sv.vehicleSplashFriendlyFire 100")
	host.rcon_invoke("sv.spawnTime 4")
	host.rcon_invoke("sv.manDownTime 0")
	BR.weaponsDisabled = 1

def sendEmphMsg(msg):
	sendMsg("================================")
	sendMsg("================================")
	sendMsg(msg)
	sendMsg("================================")
	sendMsg("================================")

def StartCheckTrigger(triggerId, cp, vehicle, enter, userData):
	if BR.raceStarted:
		pcos = bf2.triggerManager.getObjects(cp.triggerId)
		ptid = int(cp.getTemplateProperty('ControlPointID'))
		for o in pcos:
			if not o: continue
			if o.getParent(): continue
			occupyingPlayers = o.getOccupyingPlayers()
			for p in occupyingPlayers:
				if p != occupyingPlayers[0]: continue
				if p.isAlive() and not p.isManDown():
					if not p.killed:
						if p.getDefaultVehicle() != p.getVehicle():
							if BR.player_disqualified[p.getName()] < 3:
								BR.player_startcheck[p.getName()] = 1

def CheckpointTrigger(triggerId, cp, vehicle, enter, userData):
	if BR.raceStarted:
		pcos = bf2.triggerManager.getObjects(cp.triggerId)
		ptid = int(cp.getTemplateProperty('ControlPointID'))
		for o in pcos:
			if not o: continue
			if o.getParent(): continue
			occupyingPlayers = o.getOccupyingPlayers()
			for p in occupyingPlayers:
				if p != occupyingPlayers[0]: continue
				if p.isAlive() and not p.isManDown():
					if not p.killed:
						if p.getDefaultVehicle() != p.getVehicle():
							if (p.score.cpCaptures + 1) < (ptid - 2):
								playerDriveReverse(p, vehicle)
							#if (p.score.cpCaptures) == (ptid - 2):
							#	PlayerDriveReverse(p, vehicle)
							if BR.player_disqualified[p.getName()] < 3:
								if p.getTeam() == 2 and (p.score.cpCaptures) == (ptid - 3) and p.score.kills < BR.raceLaps and p.score.revives > 0:
									passTime = 0
									if BR.player_timesplit.has_key(p.getName()):
										passTime = host.timer_getWallTime() - BR.player_timesplit[p.getName()]
									if not BR.player_timesplit.has_key(p.getName()):
										passTime = host.timer_getWallTime() - BR.startTime
									sendMsg(p.getName() + " has passed Checkpoint " + str(ptid - 2) + " * split " + str(formatTime(passTime)))
									p.score.cpCaptures += 1
									addScore(p, 1, RPL)


def FinishTrigger(triggerId, cp, vehicle, enter, userData):
	pcos = bf2.triggerManager.getObjects(cp.triggerId)
	for o in pcos:
		if not o: continue
		if o.getParent(): continue
		occupyingPlayers = o.getOccupyingPlayers()
		for p in occupyingPlayers:
			if p != occupyingPlayers[0]:
				continue
			if p.isAlive() and not p.isManDown():
				if not p.killed:
					if p.getDefaultVehicle() != p.getVehicle():
						if BR.raceStarted:
							if not BR.player_startcheck[p.getName()]:
								sendMsg("FALSE START - " + str(p.getName()))
								if not BR.player_timepenalty.has_key(p.getName()):
									BR.player_timepenalty[p.getName()] = 0.0
								BR.player_timepenalty[p.getName()] += 10.0
								BR.player_startcheck[p.getName()] = 1
							if BR.player_disqualified[p.getName()] < 3:
								# Lap completed
								if p.getTeam() == 2 and (p.score.cpCaptures) == (num_pts) and p.score.cpCaptures != 0:
									p.score.cpCaptures = 0
									p.score.kills += 1
									addScore(p, 1, RPL)

									totalTime = host.timer_getWallTime() - BR.startTime
									passTime = 0

									if BR.player_timesplit.has_key(p.getName()):
										passTime = host.timer_getWallTime() - BR.player_timesplit[p.getName()]
									if not BR.player_timesplit.has_key(p.getName()):
										passTime = host.timer_getWallTime() - BR.startTime

									BR.player_timesplit[p.getName()] = host.timer_getWallTime()

									if BR.player_bestlap.has_key(p.getName()):
										if passTime < BR.player_bestlap[p.getName()]:
											BR.player_bestlap[p.getName()] = passTime
									else:
										BR.player_bestlap[p.getName()] = passTime

									sendMsg(p.getName() + " has completed lap " + str(p.score.kills) + "/" + str(BR.raceLaps) + " * laptime " + str(formatTime(passTime)) + " * total " + str(formatTime(totalTime)))

									if p.score.kills == BR.raceLaps:
										if BR.player_timepenalty.has_key(p.getName()):
											totalTime += BR.player_timepenalty[p.getName()]
										BR.player_totaltime[p.getName()] = totalTime
										try: bf2.gameLogic.sendGameEvent(p, 10, 1) # "You have finished the race." --> HUD_HUD_REPLENISH_GOT_REPAIR_POINT
										except:
											ExceptionOutput()
										checkWinners(p)
								if (p.score.cpCaptures == 0) and (not BR.player_totaltime.has_key(p.getName())):
									p.score.revives = 1
									addScore(p, 1, RPL)
						else:
							#The race hasn't started yet, player is going beyond the start line, so warn him
							try: bf2.gameLogic.sendGameEvent(p, 10, 0) # "Get behind the start line or you will be disqualified!" --> HUD_HUD_REPLENISH_GOT_HEALING_POINT
							except:
								ExceptionOutput()

def checkWinners(player):
	disableWeapons()
	numberOfPlayers = host.pmgr_getNumberOfPlayers()

	if len(BR.player_totaltime) >= numberOfPlayers:
		if not BR.displayWinnersTimer:
			BR.displayWinnersTimer = bf2.Timer(displayWinners, 0, 1)
			BR.displayWinnersTimer.setRecurring(3.0)
	else:
		if not BR.endRaceTimer:
			BR.endRaceTimer = bf2.Timer(endRaceTime, 0, 1)
			BR.endRaceTimer.setRecurring(60.0)

def endRaceTime(data):
	if BR.raceIsEnded > 0:
		if not BR.displayWinnersTimer:
			BR.displayWinnersTimer = bf2.Timer(displayWinners, 0, 1)
			BR.displayWinnersTimer.setRecurring(3.0)
		BR.endRaceTimer.destroy()
		BR.endRaceTimer = None
	else:
		BR.raceIsEnded = 1

def displayWinners(data):
	BR.displayWinnersTimerIndex += 1

	# Driver name is stored as x[0], total race time as x[1]
	sortedplayer_totaltime = sortbyvalue(BR.player_totaltime)
	if BR.displayWinnersTimerIndex < 3:
		timesIndexed = 0
		sendMsg("Top 3:")
		for x in sortedplayer_totaltime:
			timesIndexed = timesIndexed + 1
			if timesIndexed < 4:
				if timesIndexed > 1:
					try: fpDiff = " (+" + str(formatTime(x[1] - sortedplayer_totaltime[0][1])) + ")"
					except:
						ExceptionOutput()
				else:
					fpDiff = ""
				try: sendMsg(str(timesIndexed) + ". " + str(x[0].replace("<","").replace(">","")) + " * " + str(formatTime(x[1])) + fpDiff)
				except:
					ExceptionOutput()
		sendMsg("==================================")
		if timesIndexed < 3:
			sendMsg("==================================")
		if timesIndexed < 2:
			sendMsg("==================================")

	elif BR.displayWinnersTimerIndex < 7:
		timesIndexed = 0
		sendMsg("Race Results:")
		for x in sortedplayer_totaltime:
			timesIndexed = timesIndexed + 1
			if timesIndexed > 1:
				try: fpDiff = " (+" + str(formatTime(x[1] - sortedplayer_totaltime[0][1])) + ")"
				except:
					ExceptionOutput()
			else:
				fpDiff = ""
			try: sendMsg(str(timesIndexed) + ". " + str(x[0].replace("<","").replace(">","")) + " * " + str(formatTime(x[1])) + fpDiff)
			except:
				ExceptionOutput()
		if timesIndexed < 4:
			sendMsg("==================================")
		if timesIndexed < 3:
			sendMsg("==================================")
		if timesIndexed < 2:
			sendMsg("==================================")

	elif BR.displayWinnersTimerIndex < 10:
		sortedplayer_bestlap = sortbyvalue(BR.player_bestlap)
		timesIndexed = 0
		sendMsg("Best Lap Times:")
		# Driver name is stored as x[0], best time as x[1]
		for x in sortedplayer_bestlap:
			timesIndexed = timesIndexed + 1
			if timesIndexed < 4:
				try: sendMsg(str(formatTime(x[1])) + " - " + str(x[0].replace("<","").replace(">","")))
				except:
					ExceptionOutput()
		if timesIndexed < 3:
			sendMsg("==================================")
		if timesIndexed < 2:
			sendMsg("==================================")
		sendMsg("==================================")

	elif BR.displayWinnersTimerIndex == 10:
		if BR.statsCode:
			try:
				sendStats(BR.STATS_SERVER, BR.STATS_PORT)
			except:
				ExceptionOutput()
		timesIndexed = 0
		for x in sortedplayer_totaltime:
			try: x = bf2.PlayerManager.Player(BR.player_ids[x[0]])
			except:
				ExceptionOutput()
			else:
				timesIndexed = timesIndexed + 1
				if timesIndexed == 1:
					try: bf2.gameLogic.sendMedalEvent(x, 1031406, 1)
					except:
						ExceptionOutput()
				if timesIndexed == 2:
					try: bf2.gameLogic.sendMedalEvent(x, 1031406, 2)
					except:
						ExceptionOutput()
				if timesIndexed == 3:
					try: bf2.gameLogic.sendMedalEvent(x, 1031406, 3)
					except:
						ExceptionOutput()

	elif BR.displayWinnersTimerIndex == 13:
		sendMsg("Ending race...")

	elif BR.displayWinnersTimerIndex == 14:
		for p in bf2.playerManager.getPlayers():
			try: p.score.score = 0
			except:
				ExceptionOutput()
		timesIndexed = 0
		p_score = {}
		for x in sortedplayer_totaltime:
			timesIndexed = timesIndexed + 1
			if x[1] != "DNF":
				if timesIndexed == 1:
					p_score[x[0]] = 10
				if timesIndexed == 2:
					p_score[x[0]] = 8
				if timesIndexed == 3:
					p_score[x[0]] = 6
				if timesIndexed >= 4 and timesIndexed <= 8:
					p_score[x[0]] = 9 - timesIndexed
				if timesIndexed > 8:
					p_score[x[0]] = 0
			else:
				p_score[x[0]] = 0
		for p in bf2.playerManager.getPlayers():
			if BR.player_totaltime.has_key(p.getName()):
				p.score.score = p_score[p.getName()]
				if BR.player_totaltime[p.getName()] != "DNF":
					try:
						m,s,l = formatTimePart(BR.player_totaltime[p.getName()])
						p.score.cpCaptures = 0
						p.score.rplScore = m
						p.score.skillScore = 0
						p.score.kills = s
						p.score.deaths = l
					except:
						ExceptionOutput()
				else:
					try:
						p.score.score = 0
						p.score.cpCaptures = 0
						p.score.rplScore = 0
						p.score.skillScore = 0
						p.score.kills = 0
						p.score.deaths = 0
					except:
						ExceptionOutput()
			else:
				try:
					p.score.score = 0
					p.score.cpCaptures = 0
					p.score.rplScore = 0
					p.score.skillScore = 0
					p.score.kills = 0
					p.score.deaths = 0
				except:
					ExceptionOutput()
		Reset(1)

	elif BR.displayWinnersTimerIndex > 15:
		Reset(1)

def lastChanceRestart(data):
	if BR.displayWinnersTimerIndex > 15 and BR.raceStarted:
		Reset(1)
	if BR.raceStarted and not BR.weaponsDisabled:
		if BR.enableFF:
			host.rcon_invoke("sv.soldierFriendlyFire 100")
			host.rcon_invoke("sv.vehicleFriendlyFire 100")
		else:
			host.rcon_invoke("sv.soldierFriendlyFire 0")
			host.rcon_invoke("sv.vehicleFriendlyFire 0")
	host.rcon_invoke("sv.soldierSplashFriendlyFire 100")
	host.rcon_invoke("sv.vehicleSplashFriendlyFire 100")

def Reset(end_race):
	BR.destroyTimers()
	BR.__init__()
	if end_race == 1:
		EndRace()

def EndRace():
	host.sgl_endGame(2, 3)

def sendStats(sServer, sPort):

	message = ""

	print "Creating race data"
	message += BR.statsCode + "%bR%" + str(BR.BRVERSION) + "%bR%" + host.sgl_getMapName() + "%bR%" + str(BR.mapSize) + "%bR%" + str(BR.raceLaps) + "%bR%" + str(BR.enableFF) + "%bR%" + str(BR.handheldWeapons) + "%bR%" + str(BR.vehicleWeapons) + "%Rb%"

	for p in bf2.playerManager.getPlayers():
		try: BR.player_totaltime[p.getName()]
		except:
			BR.player_totaltime[p.getName()] = "DNF"
		try: BR.player_bestlap[p.getName()]
		except:
			BR.player_bestlap[p.getName()] = "DNF"

	print "Sorting times"
	try: sortedplayer_totaltime = sortbyvalue(BR.player_totaltime)
	except:
		sendMsg("+R Error 102")
		return 0

	for p in sortedplayer_totaltime:
		m = md5.new()
		m.update(str(p[0]) + str(p[1]) + "3A5UX4SS")
		#if BR.player_disqualified[p[0]] >= 2:
			#p[1] = "DQ"
		try: x = bf2.PlayerManager.Player(BR.player_ids[p[0]])
		except:
			ExceptionOutput()
			phash = "na"
		else:
			phash = x.getProfileId()
		# Hex - Keyhash - Name - TotalTime - BestLap
		try:
			message += m.hexdigest() + "%bR%" + str(phash) + "%bR%" + str(p[0]) + "%bR%" + str(p[1]) + "%bR%" + str(BR.player_bestlap[p[0]]) + "%sP%"
		except:
			ExceptionOutput()
	print "Creating socket"
	sock = socket(AF_INET, SOCK_STREAM)
	print "Setting to non-blocking"
	sock.settimeout(1.0)
	print "Connecting to stat server"
	try:
		sock.connect((sServer, sPort))
	except:
		sendMsg("+R Error 103 - Could not connect to stat server")
		ExceptionOutput()
		sock.close()
		return 0
	print "Sending message"
	messlen = 0
	tries = 0
	fail = 0
	data = ""
	while messlen < len(message):
		tries += 1
		if tries >= 2:
			print "Failed to send complete message"
			fail = 1
			break
		try: messlen += sock.send(message)
		except:
			ExceptionOutput()
		if messlen != len(message):
			print "Send looping..."

	if fail == 0:
		sendMsg("Race data sent to global stat server.")
		sendMsg("Check your records, points, and awards at http://br-central.elxx.net")
		print "Getting response"
		data = ""
		'''sock.settimeout(0.5)
		try: data = sock.recv(1024)
		except:
			data = "error"
			ExceptionOutput()
		print "Checking result"
		if data != "error":
			try:
				#exec(data)
				print data
			else:
				ExceptionOutput()'''

	print "Closing socket"
	sock.close()

def onPlayerConnect(p):
	print "Player connected"
	generateIDs()
	# dont teamswitch alive players, or they will have the wrong teams kit
	if p.isAlive(): return
	p.setTeam(2)

def onPlayerDisconnect(p):
	print "Player disconnected"
	generateIDs()

def onPlayerDeath(p, soldierObject):
	try:
		if BR.player_lastVehicle[p.getName()]:
			inCar = BR.player_lastVehicle[p.getName()].getOccupyingPlayers()
			if not inCar:
				if hasattr(BR.player_lastVehicle[p.getName()], 'setDamage'):
					try: BR.player_lastVehicle[p.getName()].setDamage(0)
					except:
						ExceptionOutput()
	except:
		ExceptionOutput()
	if BR.raceStarted:
		x = BR.player_lastVehicle[p.getName()]
		BR.player_lastVehicle[p.getName()] = 0
		if p.getTeam() == 2:
			p.score.cpCaptures = 0
			addScore(p, 1, RPL)
			if p.getSuicide():
				BR.player_lastSVehicle[p.getName()] = x
				p.setTimeToSpawn(15)
			else:
				p.setTimeToSpawn(3)

def displayPlayerPOS(data):
	for p in bf2.playerManager.getPlayers():
		if (p.getName() == "gunzip") and p.isAlive():
			vehicle = p.getVehicle()
			pPos = vehicle.getPosition()
			print pPos

def onPlayerSpawn(player, soldier):
	print "Player spawned"
	player.killed = False
	if BR.player_disqualified[player.getName()] >= 2:
		if player.getTeam() == 2:
			try: bf2.gameLogic.sendGameEvent(player, 10, 3) # "You must spawn as a Spectator for the duration of this race." --> HUD_HUD_REPLENISH_DRIVER
			except:
				ExceptionOutput()
			if hasattr(player.getDefaultVehicle(), 'setDamage'):
				try: player.getDefaultVehicle().setDamage(-1)
				except:
					ExceptionOutput()
				else: player.setTeam(1)

def onEnterVehicle(player, vehicle, freeSoldier = False):
	if player.getTeam() == 2:
		try:
			if (BR.player_lastVehicle[player.getName()]) and (BR.player_lastVehicle[player.getName()].isValid()):
				if vehicle != BR.player_lastVehicle[player.getName()]:
					inCar = BR.player_lastVehicle[player.getName()].getOccupyingPlayers()
					if not inCar:
						if hasattr(BR.player_lastVehicle[player.getName()], 'setDamage'):
							try: BR.player_lastVehicle[player.getName()].setDamage(0)
							except:
								ExceptionOutput()
		except:
			ExceptionOutput()
		try:
			if (BR.player_lastSVehicle[player.getName()]) and (BR.player_lastSVehicle[player.getName()].isValid()):
				if vehicle != BR.player_lastSVehicle[player.getName()]:
					inCar = BR.player_lastSVehicle[player.getName()].getOccupyingPlayers()
					if not inCar:
						if hasattr(BR.player_lastSVehicle[player.getName()], 'setDamage'):
							try: BR.player_lastSVehicle[player.getName()].setDamage(0)
							except:
								ExceptionOutput()
		except:
			ExceptionOutput()
	if (bf2.objectManager.getRootParent(vehicle).templateName == "jeep_faav") or (bf2.objectManager.getRootParent(vehicle).templateName == "faav_night") or (bf2.objectManager.getRootParent(vehicle).templateName == "jep_mec_paratrooper") or (bf2.objectManager.getRootParent(vehicle).templateName == "faav_nb"):
		if player.getTeam() == 2:
			if BR.raceStarted:
				if BR.player_lastVehicle[player.getName()]:
					if bf2.objectManager.getRootParent(vehicle) != bf2.objectManager.getRootParent(BR.player_lastVehicle[player.getName()]):
						print "Exit penalty set"
						BR.player_setExitPenalty[player.getName()] = 1
			BR.player_currVehicle[player.getName()] = vehicle
			BR.player_lastVehicle[player.getName()] = 0
		else:
			if hasattr(player.getDefaultVehicle(), 'setDamage'):
				try: player.getDefaultVehicle().setDamage(-1)
				except:
					ExceptionOutput()
			if hasattr(vehicle, 'setDamage'):
				try: vehicle.setDamage(1)
				except:
					ExceptionOutput()
	updateCaptureStatus(vehicle)

def onExitVehicle(player, vehicle):
	print "Player exiting ", player.getName()
	BR.player_currVehicle[player.getName()] = 0
	BR.player_lastVehicle[player.getName()] = vehicle
	BR.player_lastSVehicle[player.getName()] = vehicle
	#if not BR.raceStarted:
	#	if hasattr(vehicle, 'setDamage'):
	#		try: vehicle.setDamage(1)
	#		except:
	#			ExceptionOutput()
	cp = getOccupyingCP(player)
	player.setIsInsideCP(cp != None and cp.cp_getParam('unableToChangeTeam') == 0)
	updateCaptureStatus(vehicle)

def playerDriveReverse(player, vehicle):
	if not BR.player_totaltime.has_key(player.getName()):
		BR.player_disqualified[player.getName()] = 2
		BR.player_setExitPenalty[player.getName()] = 1
		sendMsg(str(player.getName()) + " is driving the wrong way!")

def onDropKit(p, k):
	if p.getTeam() == 1:
		if p.isAlive():
			if hasattr(p.getDefaultVehicle(), 'setDamage'):
				try:
					p.getDefaultVehicle().setDamage(-1)
				except:
					ExceptionOutput()

def checkPenalty(data):
	dq_checker = 0
	for player in bf2.playerManager.getPlayers():
		try:
			BR.player_resetTime[player.getName()] += 1
			if (BR.player_reset.has_key(player.getName())) and (BR.player_resetTime[player.getName()] >= 1):
				if player.getVehicle() != player.getDefaultVehicle():
					pVeh = player.getVehicle()
					pNPos = pVeh.getPosition()
					pPos = BR.player_reset[player.getName()][0]
					if getVectorDistance(pNPos,pPos) < 12.0:
						pRot = BR.player_reset[player.getName()][1]
						pVeh.setRotation((pRot[0],0.0,0.0))
						pVeh.setPosition((pPos[0],pPos[1] + 3.5,pPos[2]))
						BR.player_resetTime[player.getName()] = 0
						del BR.player_reset[player.getName()]
		except:
			pass
		if BR.player_disqualified.has_key(player.getName()):
			if BR.player_disqualified[player.getName()] < 2:
				dq_checker = 1
		if (not BR.player_totaltime.has_key(player.getName())):
			if BR.player_setExitPenalty[player.getName()]:
				print "Penalizing player"
				if BR.player_disqualified[player.getName()] < 2:
					sendMsg("15-second penalty assessed to " + str(player.getName()) + " for changing vehicles")
					if not BR.player_timepenalty.has_key(player.getName()):
						BR.player_timepenalty[player.getName()] = 0.0
					BR.player_timepenalty[player.getName()] += 15.0
					BR.player_disqualified[player.getName()] += 1
				if BR.player_disqualified[player.getName()] == 2:
					print "DQing player"
					sendMsg(str(player.getName()) + " has been disqualified from this race")
					try: bf2.gameLogic.sendGameEvent(player, 10, 2) # "You have been disqualified from the race." --> HUD_HUD_REPLENISH_GOT_AMMO_POINT
					except:
						ExceptionOutput()
					if player.getVehicle() == player.getDefaultVehicle():
						print "Soldier DQ"
						if hasattr(player.getDefaultVehicle(), 'setDamage'):
							try:
								player.getDefaultVehicle().setDamage(-1)
							except:
								ExceptionOutput()
					else:
						occupyingPlayers = player.getVehicle().getOccupyingPlayers()
						if player == occupyingPlayers[0]:
							print "Vehicle DQ"
							if hasattr(player.getVehicle(), 'setDamage'):
								try:
									player.getVehicle().setDamage(1)
								except:
									ExceptionOutput()
				BR.player_setExitPenalty[player.getName()] = 0
	if dq_checker == 0 and bf2.playerManager.getNumberOfPlayers() >= 1:
		Reset(1)

def onPlayerKilled(victim, attacker, weapon, assists, object):
	# check if killed by vehicle in motion
	if weapon == None and object != None:
		if hasattr(object, 'lastDrivingPlayerIndex'):
			attacker = bf2.playerManager.getPlayerByIndex(object.lastDrivingPlayerIndex)
			killedByEmptyVehicle = True
	if attacker == victim:
		victim.setTimeToSpawn(5)
		if killedByEmptyVehicle and object.getIsWreck():
			return
		victim.score.cpCaptures = 0
	elif attacker.getTeam() == 2 and victim.getTeam() == 2:
		if victim.getTimeToSpawn() != 0:
			victim.setTimeToSpawn(5)
	else:
		victim.setTimeToSpawn(5)

def updateCaptureStatus(vehicle):
	rootVehicle = bf2.objectManager.getRootParent(vehicle)
	playersInVehicle = rootVehicle.getOccupyingPlayers()
	for p in playersInVehicle:
		print "Players in vehicle ", p.getName()
		cp = getOccupyingCP(p)
		p.setIsInsideCP(cp != None and cp.cp_getParam('unableToChangeTeam') == 0 and p == playersInVehicle[0])

def getOccupyingCP(player):
	vehicle = player.getVehicle()
	playerPos = vehicle.getPosition()

	closestCP = None
	if len(g_controlPoints) == 0: return None
	for obj in g_controlPoints:
		distanceTo = getVectorDistance(playerPos, obj.getPosition())
		if closestCP == None or distanceTo < closestCPdist:
			closestCP = obj
			closestCPdist = distanceTo

	pcos = bf2.triggerManager.getObjects(closestCP.triggerId)
	for o in pcos:
		if o == player.getDefaultVehicle():
			return closestCP
		else:
			for p in o.getOccupyingPlayers():
				if p == player:
					return closestCP

	return None

def getVectorDistance(pos1, pos2):
	diffVec = [0.0, 0.0, 0.0]
	diffVec[0] = math.fabs(pos1[0] - pos2[0])
	diffVec[1] = math.fabs(pos1[1] - pos2[1])
	diffVec[2] = math.fabs(pos1[2] - pos2[2])
	return math.sqrt(diffVec[0] * diffVec[0] + diffVec[1] * diffVec[1] + diffVec[2] * diffVec[2])